#include <catch2/catch.hpp>

#include <ASTNodeValueBuilder.hpp>

#include <ASTBuilder.hpp>
#include <ASTNodeDataTypeBuilder.hpp>

#include <ASTNodeDeclarationToAffectationConverter.hpp>
#include <ASTNodeTypeCleaner.hpp>

#include <ASTNodeExpressionBuilder.hpp>

#include <ASTNodeAffectationExpressionBuilder.hpp>

#include <ASTSymbolTableBuilder.hpp>

#include <ASTPrinter.hpp>

#include <Demangle.hpp>

#include <PEGGrammar.hpp>

#include <sstream>

#define CHECK_INC_DEC_RESULT(data, variable_name, expected_value)             \
  {                                                                           \
    string_input input{data, "test.pgs"};                                     \
    auto ast = ASTBuilder::build(input);                                      \
                                                                              \
    ASTSymbolTableBuilder{*ast};                                              \
    ASTNodeDataTypeBuilder{*ast};                                             \
    ASTNodeValueBuilder{*ast};                                                \
                                                                              \
    ASTNodeDeclarationToAffectationConverter{*ast};                           \
    ASTNodeTypeCleaner<language::declaration>{*ast};                          \
                                                                              \
    ASTNodeExpressionBuilder{*ast};                                           \
    ExecUntilBreakOrContinue exec_policy;                                     \
    ast->execute(exec_policy);                                                \
                                                                              \
    auto symbol_table = ast->m_symbol_table;                                  \
                                                                              \
    using namespace TAO_PEGTL_NAMESPACE;                                      \
    position use_position{internal::iterator{"fixture"}, "fixture"};          \
    use_position.byte    = 10000;                                             \
    auto [symbol, found] = symbol_table->find(variable_name, use_position);   \
                                                                              \
    auto attributes = symbol->attributes();                                   \
    auto value      = std::get<decltype(expected_value)>(attributes.value()); \
                                                                              \
    REQUIRE(value == expected_value);                                         \
  }

TEST_CASE("IncDecExpressionProcessor", "[language]")
{
  SECTION("pre ++")
  {
    SECTION("N")
    {
      CHECK_INC_DEC_RESULT(R"(N n = 2; ++n;)", "n", 3ul);
      CHECK_INC_DEC_RESULT(R"(N n = 2; N m = ++n;)", "m", 3ul);
    }

    SECTION("Z")
    {
      CHECK_INC_DEC_RESULT(R"(Z z = 2; ++z;)", "z", 3l);
      CHECK_INC_DEC_RESULT(R"(Z z = 2; Z p = ++z;)", "p", 3l);
    }

    SECTION("R")
    {
      CHECK_INC_DEC_RESULT(R"(R r = 2; ++r;)", "r", 3.);
      CHECK_INC_DEC_RESULT(R"(R r = 2; R s = ++r;)", "s", 3.);
    }
  }

  SECTION("pre --")
  {
    SECTION("N")
    {
      CHECK_INC_DEC_RESULT(R"(N n = 2; --n;)", "n", 1ul);
      CHECK_INC_DEC_RESULT(R"(N n = 2; N m = --n;)", "m", 1ul);
    }

    SECTION("Z")
    {
      CHECK_INC_DEC_RESULT(R"(Z z = 2; --z;)", "z", 1l);
      CHECK_INC_DEC_RESULT(R"(Z z = 2; Z p = --z;)", "p", 1l);
    }

    SECTION("R")
    {
      CHECK_INC_DEC_RESULT(R"(R r = 2; --r;)", "r", 1.);
      CHECK_INC_DEC_RESULT(R"(R r = 2; R s = --r;)", "s", 1.);
    }
  }

  SECTION("post ++")
  {
    SECTION("N")
    {
      CHECK_INC_DEC_RESULT(R"(N n = 2; n++;)", "n", 3ul);
      CHECK_INC_DEC_RESULT(R"(N n = 2; N m = n++;)", "m", 2ul);
    }

    SECTION("Z")
    {
      CHECK_INC_DEC_RESULT(R"(Z z = 2; z++;)", "z", 3l);
      CHECK_INC_DEC_RESULT(R"(Z z = 2; Z p = z++;)", "p", 2l);
    }

    SECTION("R")
    {
      CHECK_INC_DEC_RESULT(R"(R r = 2; r++;)", "r", 3.);
      CHECK_INC_DEC_RESULT(R"(R r = 2; R s = r++;)", "s", 2.);
    }
  }

  SECTION("post --")
  {
    SECTION("N")
    {
      CHECK_INC_DEC_RESULT(R"(N n = 2; n--;)", "n", 1ul);
      CHECK_INC_DEC_RESULT(R"(N n = 2; N m = n--;)", "m", 2ul);
    }

    SECTION("Z")
    {
      CHECK_INC_DEC_RESULT(R"(Z z = 2; z--;)", "z", 1l);
      CHECK_INC_DEC_RESULT(R"(Z z = 2; Z p = z--;)", "p", 2l);
    }

    SECTION("R")
    {
      CHECK_INC_DEC_RESULT(R"(R r = 2; r--;)", "r", 1.);
      CHECK_INC_DEC_RESULT(R"(R r = 2; R s = r--;)", "s", 2.);
    }
  }
}
