#include <catch2/catch.hpp>

#include <ASTNodeValueBuilder.hpp>

#include <ASTBuilder.hpp>
#include <ASTNodeDataTypeBuilder.hpp>

#include <ASTNodeDeclarationToAffectationConverter.hpp>
#include <ASTNodeTypeCleaner.hpp>

#include <ASTNodeExpressionBuilder.hpp>

#include <ASTNodeAffectationExpressionBuilder.hpp>

#include <ASTSymbolTableBuilder.hpp>

#include <ASTPrinter.hpp>

#include <Demangle.hpp>

#include <PEGGrammar.hpp>

#include <sstream>

#define CHECK_IF_PROCESSOR_RESULT(data, variable_name, expected_value)        \
  {                                                                           \
    string_input input{data, "test.pgs"};                                     \
    auto ast = ASTBuilder::build(input);                                      \
                                                                              \
    ASTSymbolTableBuilder{*ast};                                              \
    ASTNodeDataTypeBuilder{*ast};                                             \
    ASTNodeValueBuilder{*ast};                                                \
                                                                              \
    ASTNodeDeclarationToAffectationConverter{*ast};                           \
    ASTNodeTypeCleaner<language::declaration>{*ast};                          \
                                                                              \
    ASTNodeExpressionBuilder{*ast};                                           \
    ExecUntilBreakOrContinue exec_policy;                                     \
    ast->execute(exec_policy);                                                \
                                                                              \
    auto symbol_table = ast->m_symbol_table;                                  \
                                                                              \
    using namespace TAO_PEGTL_NAMESPACE;                                      \
    position use_position{internal::iterator{"fixture"}, "fixture"};          \
    use_position.byte    = 10000;                                             \
    auto [symbol, found] = symbol_table->find(variable_name, use_position);   \
                                                                              \
    auto attributes = symbol->attributes();                                   \
    auto value      = std::get<decltype(expected_value)>(attributes.value()); \
                                                                              \
    REQUIRE(value == expected_value);                                         \
  }

TEST_CASE("IfProcessor", "[language]")
{
  SECTION("simple if(true)")
  {
    std::string_view data = R"(
N i = 0;
if(true) {
  i = 1;
}
)";
    CHECK_IF_PROCESSOR_RESULT(data, "i", 1ul);
  }

  SECTION("simple if(false)")
  {
    std::string_view data = R"(
N i = 0;
if(false) {
  i = 1;
}
)";
    CHECK_IF_PROCESSOR_RESULT(data, "i", 0ul);
  }

  SECTION("simple if(true)else")
  {
    std::string_view data = R"(
N i = 0;
if(true) {
  i = 1;
} else {
  i = 2;
}
)";
    CHECK_IF_PROCESSOR_RESULT(data, "i", 1ul);
  }

  SECTION("simple if(false)")
  {
    std::string_view data = R"(
N i = 0;
if(false) {
  i = 1;
} else {
  i = 2;
}
)";
    CHECK_IF_PROCESSOR_RESULT(data, "i", 2ul);
  }
}
