#include <catch2/catch.hpp>

#include <Demangle.hpp>
#include <node_processor/FakeProcessor.hpp>

#include <rang.hpp>

TEST_CASE("INodeProcessor", "[language]")
{
  rang::setControlMode(rang::control::Off);

  std::unique_ptr<INodeProcessor> node_processor = std::make_unique<FakeProcessor>();
  REQUIRE(node_processor->typeIdName() == demangle<FakeProcessor>());

  ExecUntilBreakOrContinue exec_policy;
  REQUIRE_NOTHROW(node_processor->execute(exec_policy));
}
