#include <catch2/catch.hpp>

#include <ASTNodeValueBuilder.hpp>

#include <ASTBuilder.hpp>
#include <ASTNodeDataTypeBuilder.hpp>

#include <ASTNodeDeclarationToAffectationConverter.hpp>
#include <ASTNodeTypeCleaner.hpp>

#include <ASTNodeExpressionBuilder.hpp>

#include <ASTNodeAffectationExpressionBuilder.hpp>

#include <ASTSymbolTableBuilder.hpp>

#include <ASTPrinter.hpp>

#include <Demangle.hpp>

#include <PEGGrammar.hpp>

#include <sstream>

#define CHECK_FOR_PROCESSOR_RESULT(data, variable_name, expected_value)       \
  {                                                                           \
    string_input input{data, "test.pgs"};                                     \
    auto ast = ASTBuilder::build(input);                                      \
                                                                              \
    ASTSymbolTableBuilder{*ast};                                              \
    ASTNodeDataTypeBuilder{*ast};                                             \
    ASTNodeValueBuilder{*ast};                                                \
                                                                              \
    ASTNodeDeclarationToAffectationConverter{*ast};                           \
    ASTNodeTypeCleaner<language::declaration>{*ast};                          \
                                                                              \
    ASTNodeExpressionBuilder{*ast};                                           \
    ExecUntilBreakOrContinue exec_policy;                                     \
    ast->execute(exec_policy);                                                \
                                                                              \
    auto symbol_table = ast->m_symbol_table;                                  \
                                                                              \
    using namespace TAO_PEGTL_NAMESPACE;                                      \
    position use_position{internal::iterator{"fixture"}, "fixture"};          \
    use_position.byte    = 10000;                                             \
    auto [symbol, found] = symbol_table->find(variable_name, use_position);   \
                                                                              \
    auto attributes = symbol->attributes();                                   \
    auto value      = std::get<decltype(expected_value)>(attributes.value()); \
                                                                              \
    REQUIRE(value == expected_value);                                         \
  }

TEST_CASE("ForProcessor", "[language]")
{
  SECTION("simple for")
  {
    std::string_view data = R"(
N i = 0;
for(N l=0; l<10; ++l) {
  i += l;
}
)";
    CHECK_FOR_PROCESSOR_RESULT(data, "i", 45ul);
  }

  SECTION("for with break")
  {
    std::string_view data = R"(
N i = 0;
for(N l=0; l<10; ++l) {
  i += l;
  if (i > 30) break;
}
)";
    CHECK_FOR_PROCESSOR_RESULT(data, "i", 36ul);
  }

  SECTION("for with continue")
  {
    std::string_view data = R"(
N i = 0;
for(N l=0; l<10; ++l) {
  if (l<3) continue;
  i += l;
}
)";
    CHECK_FOR_PROCESSOR_RESULT(data, "i", 42ul);
  }
}
