#include <catch2/catch.hpp>

#include <node_processor/ExecUntilBreakOrContinue.hpp>

#include <rang.hpp>

TEST_CASE("ExecUntilBreakOrContinue", "[language]")
{
  rang::setControlMode(rang::control::Off);

  ExecUntilBreakOrContinue exec_policy;
  SECTION("no jump")
  {
    exec_policy = ExecUntilBreakOrContinue{ExecUntilBreakOrContinue::JumpType::no_jump};
    REQUIRE(exec_policy.exec() == true);
    REQUIRE(exec_policy.jumpType() == ExecUntilBreakOrContinue::JumpType::no_jump);
  }

  SECTION("break jump")
  {
    exec_policy = ExecUntilBreakOrContinue{ExecUntilBreakOrContinue::JumpType::break_jump};
    REQUIRE(exec_policy.exec() == false);
    REQUIRE(exec_policy.jumpType() == ExecUntilBreakOrContinue::JumpType::break_jump);
  }

  SECTION("continue jump")
  {
    exec_policy = ExecUntilBreakOrContinue{ExecUntilBreakOrContinue::JumpType::continue_jump};
    REQUIRE(exec_policy.exec() == false);
    REQUIRE(exec_policy.jumpType() == ExecUntilBreakOrContinue::JumpType::continue_jump);
  }
}
