#include <catch2/catch.hpp>

#include "test_BinaryExpressionProcessor_utils.hpp"

TEST_CASE("BinaryExpressionProcessor logic", "[language]")
{
  SECTION("and")
  {
    SECTION("lhs is B")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = true and true;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = false and true;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 1; B b = true and n;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = true and n;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 1; B b = false and n;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = true and -3;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = true and 0;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = false and 1;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = false and 1.;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = true and 0.;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = true and -1.7;)", "b", true);
    }

    SECTION("lhs is N")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 1; B b = n and true;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = n and true;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 1; B b = n and false;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = n and false;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 4; N m = 2; B b = n and m;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 1; N m = 0; B b = n and m;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 4; B b = n and -1;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 4; B b = n and 0;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = n and -1;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = n and 0;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 1; B b = n and 2.3;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 1; B b = n and 0.;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = n and 2.3;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = n and 0.;)", "b", false);
    }

    SECTION("lhs is Z")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1 and true;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1 and false;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0 and true;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0 and false;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 4; B b = -3 and n;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = -3 and n;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 4; B b = 0 and n;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = 0 and n;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 1 and 2;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 1 and 0;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0 and 2;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0 and 0;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 3 and 2.5;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 3 and 0.;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0 and 2.5;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0 and 0.;)", "b", false);
    }

    SECTION("lhs is R")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1.2 and true;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1.2 and false;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0. and true;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0. and false;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 2; B b = -1.2 and n;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = -1.2 and n;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 2; B b = 0. and n;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = 0. and n;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1.2 and 1;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1.2 and 0;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0. and 1;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0. and 0;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1.2 and 2.3;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1.2 and 0.;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0. and 2.3;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0. and 0.;)", "b", false);
    }
  }

  SECTION("or")
  {
    SECTION("lhs is B")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = true or true;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = false or true;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 1; B b = true or n;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = true or n;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 1; B b = false or n;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = false or n;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = true or -3;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = true or 0;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = false or 0;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = false or 1;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = false or 1.;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = true or 0.;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = false or 0.;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = true or -1.7;)", "b", true);
    }

    SECTION("lhs is N")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 1; B b = n or true;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = n or true;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 1; B b = n or false;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = n or false;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 4; N m = 2; B b = n or m;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 1; N m = 0; B b = n or m;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; N m = 2; B b = n or m;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; N m = 0; B b = n or m;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 4; B b = n or -1;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 4; B b = n or 0;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = n or -1;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = n or 0;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 1; B b = n or 2.3;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 1; B b = n or 0.;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = n or 2.3;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = n or 0.;)", "b", false);
    }

    SECTION("lhs is Z")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1 or true;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1 or false;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0 or true;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0 or false;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 4; B b = -3 or n;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = -3 or n;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 4; B b = 0 or n;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = 0 or n;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 1 or 2;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 1 or 0;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0 or 2;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0 or 0;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 3 or 2.5;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 3 or 0.;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0 or 2.5;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0 or 0.;)", "b", false);
    }

    SECTION("lhs is R")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1.2 or true;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1.2 or false;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0. or true;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0. or false;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 2; B b = -1.2 or n;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = -1.2 or n;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 2; B b = 0. or n;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(N n = 0; B b = 0. or n;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1.2 or 1;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1.2 or 0;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0. or 1;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0. or 0;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1.2 or 2.3;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = -1.2 or 0.;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0. or 2.3;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = 0. or 0.;)", "b", false);
    }
  }

  SECTION("xor")
  {
    SECTION("lhs is B")
    {
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = true xor true;)", "b", false);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = false xor true;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = true xor false;)", "b", true);
      CHECK_BINARY_EXPRESSION_RESULT(R"(B b = false xor false;)", "b", false);
    }
  }
}
