#include <catch2/catch.hpp>

#include <Array.hpp>
#include <ArrayUtils.hpp>
#include <PugsAssert.hpp>

#include <TinyMatrix.hpp>
#include <TinyVector.hpp>

// Instantiate to ensure full coverage is performed
template class Array<int>;

TEST_CASE("ArrayUtils", "[utils]")
{
  SECTION("checking for Array reductions")
  {
    Array<int> a(10);
    a[0] = 13;
    a[1] = 1;
    a[2] = 8;
    a[3] = -3;
    a[4] = 23;
    a[5] = -1;
    a[6] = 13;
    a[7] = 0;
    a[8] = 12;
    a[9] = 9;

    SECTION("Min")
    {
      REQUIRE((min(a) == -3));
    }

    SECTION("Max")
    {
      REQUIRE((max(a) == 23));
    }

    SECTION("Sum")
    {
      REQUIRE((sum(a) == 75));
    }

    SECTION("TinyVector Sum")
    {
      using N2 = TinyVector<2, int>;
      Array<N2> b(10);
      b[0] = {13, 2};
      b[1] = {1, 3};
      b[2] = {8, -2};
      b[3] = {-3, 2};
      b[4] = {23, 4};
      b[5] = {-1, -3};
      b[6] = {13, 17};
      b[7] = {0, 9};
      b[8] = {12, 13};
      b[9] = {9, -17};

      REQUIRE((sum(b) == N2{75, 28}));
    }

    SECTION("TinyMatrix Sum")
    {
      using N22 = TinyMatrix<2, int>;
      Array<N22> b(10);
      b[0] = {13, 2, 0, 1};
      b[1] = {1, 3, 6, 3};
      b[2] = {8, -2, -1, 21};
      b[3] = {-3, 2, 5, 12};
      b[4] = {23, 4, 7, 1};
      b[5] = {-1, -3, 33, 11};
      b[6] = {13, 17, 12, 13};
      b[7] = {0, 9, 1, 14};
      b[8] = {12, 13, -3, -71};
      b[9] = {9, -17, 0, 16};

      REQUIRE((sum(b) == N22{75, 28, 60, 21}));
    }
  }
}
