#include <catch2/catch.hpp>

#include <ASTNodeValueBuilder.hpp>

#include <ASTBuilder.hpp>
#include <ASTNodeDataTypeBuilder.hpp>

#include <ASTNodeDeclarationToAffectationConverter.hpp>
#include <ASTNodeTypeCleaner.hpp>

#include <ASTNodeExpressionBuilder.hpp>

#include <ASTNodeAffectationExpressionBuilder.hpp>

#include <ASTSymbolTableBuilder.hpp>

#include <ASTPrinter.hpp>

#include <Demangle.hpp>

#include <PEGGrammar.hpp>

#include <sstream>

#define CHECK_AFFECTATION_RESULT(data, variable_name, expected_value)         \
  {                                                                           \
    string_input input{data, "test.pgs"};                                     \
    auto ast = ASTBuilder::build(input);                                      \
                                                                              \
    ASTSymbolTableBuilder{*ast};                                              \
    ASTNodeDataTypeBuilder{*ast};                                             \
    ASTNodeValueBuilder{*ast};                                                \
                                                                              \
    ASTNodeDeclarationToAffectationConverter{*ast};                           \
    ASTNodeTypeCleaner<language::declaration>{*ast};                          \
                                                                              \
    ASTNodeExpressionBuilder{*ast};                                           \
    ExecUntilBreakOrContinue exec_policy;                                     \
    ast->execute(exec_policy);                                                \
                                                                              \
    auto symbol_table = ast->m_symbol_table;                                  \
                                                                              \
    using namespace TAO_PEGTL_NAMESPACE;                                      \
    position use_position{internal::iterator{"fixture"}, "fixture"};          \
    use_position.byte    = 10000;                                             \
    auto [symbol, found] = symbol_table->find(variable_name, use_position);   \
                                                                              \
    auto attributes = symbol->attributes();                                   \
    auto value      = std::get<decltype(expected_value)>(attributes.value()); \
                                                                              \
    REQUIRE(value == expected_value);                                         \
  }

TEST_CASE("ASTAffectationToStringProcessor", "[language]")
{
  SECTION("Affectations")
  {
    CHECK_AFFECTATION_RESULT(R"(string s; s = "foo";)", "s", std::string("foo"));
    CHECK_AFFECTATION_RESULT(R"(N n = 2; string s; s = n;)", "s", std::to_string(2ul));
    CHECK_AFFECTATION_RESULT(R"(string s; s = -1;)", "s", std::to_string(-1l));
    CHECK_AFFECTATION_RESULT(R"(string s; s = true;)", "s", std::to_string(true));
    CHECK_AFFECTATION_RESULT(R"(string s; s = 2.3;)", "s", std::to_string(2.3));
  }

  SECTION("+=")
  {
    CHECK_AFFECTATION_RESULT(R"(string s = "foo"; s += "bar";)", "s", std::string("foobar"));
    CHECK_AFFECTATION_RESULT(R"(N n = 2; string s = "foo"; s += n;)", "s", (std::string("foo") + std::to_string(2ul)));
    CHECK_AFFECTATION_RESULT(R"(string s = "foo"; s += -1;)", "s", (std::string("foo") + std::to_string(-1l)));
    CHECK_AFFECTATION_RESULT(R"(string s = "foo"; s += true;)", "s", (std::string("foo") + std::to_string(true)));
    CHECK_AFFECTATION_RESULT(R"(string s = "foo"; s += 2.3;)", "s", (std::string("foo") + std::to_string(2.3)));
  }
}
