#include <catch2/catch.hpp>

#include <ASTBuilder.hpp>
#include <ASTSymbolTableBuilder.hpp>

TEST_CASE("ASTSymbolTableBuilder", "[language]")
{
  SECTION("Build symbols")
  {
    std::string_view data = R"(
N n = 2;
{
 N m = n;
 R n = m/3.;
}
)";

    string_input input{data, "test.pgs"};
    auto ast = ASTBuilder::build(input);

    ASTSymbolTableBuilder{*ast};
  }

  SECTION("errors")
  {
    SECTION("Undeclared symbol")
    {
      std::string_view data = R"(
N n = a;
)";

      string_input input{data, "test.pgs"};
      auto ast = ASTBuilder::build(input);

      REQUIRE_THROWS_AS(ASTSymbolTableBuilder{*ast}, parse_error);
    }

    SECTION("Re-declared symbol")
    {
      std::string_view data = R"(
N n = 0;
N n = 1;
)";

      string_input input{data, "test.pgs"};
      auto ast = ASTBuilder::build(input);

      REQUIRE_THROWS_AS(ASTSymbolTableBuilder{*ast}, parse_error);
    }

    SECTION("Re-declared symbol (function)")
    {
      std::string_view data = R"(
N f;
let f : R -> R, x -> 1;
)";

      string_input input{data, "test.pgs"};
      auto ast = ASTBuilder::build(input);

      REQUIRE_THROWS_AS(ASTSymbolTableBuilder{*ast}, parse_error);
    }

    SECTION("Re-declared parameter (function)")
    {
      std::string_view data = R"(
let f : R*R*N -> R, (x,y,x) -> 1;
)";

      string_input input{data, "test.pgs"};
      auto ast = ASTBuilder::build(input);

      REQUIRE_THROWS_AS(ASTSymbolTableBuilder{*ast}, parse_error);
    }
  }
}
