#include <catch2/catch.hpp>

#include <ASTNodeValueBuilder.hpp>

#include <ASTBuilder.hpp>
#include <ASTNodeDataTypeBuilder.hpp>

#include <ASTNodeDeclarationToAffectationConverter.hpp>
#include <ASTNodeTypeCleaner.hpp>

#include <ASTSymbolTableBuilder.hpp>

#include <ASTNodeExpressionBuilder.hpp>

#include <Demangle.hpp>

#include <node_processor/ASTNodeListProcessor.hpp>

#include <PEGGrammar.hpp>

TEST_CASE("ASTNodeListProcessor", "[language]")
{
  rang::setControlMode(rang::control::Off);

  std::string_view data = R"(
3;
true;
2.3;
)";

  string_input input{data, "test.pgs"};
  auto ast = ASTBuilder::build(input);

  ASTSymbolTableBuilder{*ast};
  ASTNodeDataTypeBuilder{*ast};
  ASTNodeValueBuilder{*ast};

  ASTNodeDeclarationToAffectationConverter{*ast};
  ASTNodeTypeCleaner<language::declaration>{*ast};

  ASTNodeExpressionBuilder{*ast};
  ExecUntilBreakOrContinue exec_policy;
  ast->execute(exec_policy);

  REQUIRE(ast->children[0]->is_type<language::integer>());
  REQUIRE(ast->children[1]->is_type<language::true_kw>());
  REQUIRE(ast->children[2]->is_type<language::real>());

  REQUIRE(ast->m_node_processor->typeIdName() == demangle<ASTNodeListProcessor>());
}
