#include <catch2/catch.hpp>

#include <ASTNodeDataType.hpp>

TEST_CASE("ASTNodeDataType", "[language]")
{
  SECTION("dataTypeName")
  {
    REQUIRE(dataTypeName(ASTNodeDataType::undefined_t) == "undefined");
    REQUIRE(dataTypeName(ASTNodeDataType::bool_t) == "B");
    REQUIRE(dataTypeName(ASTNodeDataType::unsigned_int_t) == "N");
    REQUIRE(dataTypeName(ASTNodeDataType::int_t) == "Z");
    REQUIRE(dataTypeName(ASTNodeDataType::double_t) == "R");
    REQUIRE(dataTypeName(ASTNodeDataType::string_t) == "string");
    REQUIRE(dataTypeName(ASTNodeDataType::typename_t) == "typename");
    REQUIRE(dataTypeName(ASTNodeDataType::void_t) == "void");
    REQUIRE(dataTypeName(ASTNodeDataType::function_t) == "function");
    REQUIRE(dataTypeName(ASTNodeDataType::c_function_t) == "c_function");
  }

  SECTION("promotion")
  {
    REQUIRE(dataTypePromotion(ASTNodeDataType::undefined_t, ASTNodeDataType::undefined_t) ==
            ASTNodeDataType::undefined_t);
    REQUIRE(dataTypePromotion(ASTNodeDataType::void_t, ASTNodeDataType::double_t) == ASTNodeDataType::undefined_t);
    REQUIRE(dataTypePromotion(ASTNodeDataType::int_t, ASTNodeDataType::undefined_t) == ASTNodeDataType::undefined_t);
    REQUIRE(dataTypePromotion(ASTNodeDataType::double_t, ASTNodeDataType::bool_t) == ASTNodeDataType::double_t);
    REQUIRE(dataTypePromotion(ASTNodeDataType::double_t, ASTNodeDataType::unsigned_int_t) == ASTNodeDataType::double_t);
    REQUIRE(dataTypePromotion(ASTNodeDataType::double_t, ASTNodeDataType::int_t) == ASTNodeDataType::double_t);
    REQUIRE(dataTypePromotion(ASTNodeDataType::int_t, ASTNodeDataType::unsigned_int_t) ==
            ASTNodeDataType::unsigned_int_t);
    REQUIRE(dataTypePromotion(ASTNodeDataType::int_t, ASTNodeDataType::bool_t) == ASTNodeDataType::int_t);
    REQUIRE(dataTypePromotion(ASTNodeDataType::unsigned_int_t, ASTNodeDataType::bool_t) ==
            ASTNodeDataType::unsigned_int_t);

    REQUIRE(dataTypePromotion(ASTNodeDataType::string_t, ASTNodeDataType::bool_t) == ASTNodeDataType::string_t);
    REQUIRE(dataTypePromotion(ASTNodeDataType::string_t, ASTNodeDataType::int_t) == ASTNodeDataType::string_t);
    REQUIRE(dataTypePromotion(ASTNodeDataType::string_t, ASTNodeDataType::unsigned_int_t) == ASTNodeDataType::string_t);
    REQUIRE(dataTypePromotion(ASTNodeDataType::string_t, ASTNodeDataType::double_t) == ASTNodeDataType::string_t);

    REQUIRE(dataTypePromotion(ASTNodeDataType::bool_t, ASTNodeDataType::string_t) == ASTNodeDataType::undefined_t);
    REQUIRE(dataTypePromotion(ASTNodeDataType::int_t, ASTNodeDataType::string_t) == ASTNodeDataType::undefined_t);
    REQUIRE(dataTypePromotion(ASTNodeDataType::unsigned_int_t, ASTNodeDataType::string_t) ==
            ASTNodeDataType::undefined_t);
    REQUIRE(dataTypePromotion(ASTNodeDataType::double_t, ASTNodeDataType::string_t) == ASTNodeDataType::undefined_t);
  }
}
