#include <catch2/catch.hpp>

#include <ASTNode.hpp>
#include <node_processor/FakeProcessor.hpp>

#include <Demangle.hpp>
#include <PEGGrammar.hpp>

TEST_CASE("ASTNode", "[language]")
{
  rang::setControlMode(rang::control::Off);
  SECTION("execute")
  {
    ASTNode ast_node;
    ExecUntilBreakOrContinue exec_policy;

#ifndef NDEBUG
    REQUIRE_THROWS(ast_node.execute(exec_policy));
#endif   // NDEBUG

    ast_node.m_node_processor = std::make_unique<FakeProcessor>();

    REQUIRE_NOTHROW(ast_node.execute(exec_policy));
  }

  SECTION("name")
  {
    ASTNode ast_node;
    ExecUntilBreakOrContinue exec_policy;

    ast_node.set_type<language::name>();

    REQUIRE(ast_node.name() == demangle<language::name>());
  }
}
