#include <catch2/catch.hpp>

#include <ASTBuilder.hpp>
#include <ASTDotPrinter.hpp>
#include <sstream>

#define CHECK_DOT(data, expected_output)                                                      \
  {                                                                                           \
    static_assert(std::is_same_v<std::decay_t<decltype(data)>, std::string_view>);            \
    static_assert(std::is_same_v<std::decay_t<decltype(expected_output)>, std::string_view>); \
                                                                                              \
    string_input input{data, "test.pgs"};                                                     \
    auto ast = ASTBuilder::build(input);                                                      \
                                                                                              \
    std::stringstream ast_output;                                                             \
    ast_output << '\n' << ASTDotPrinter{*ast};                                                \
                                                                                              \
    REQUIRE(ast_output.str() == expected_output);                                             \
  }

TEST_CASE("ASTDotPrinter", "[language]")
{
  rang::setControlMode(rang::control::Off);

  std::string_view data = R"(
N n = 2 + 3;
)";

  std::string_view result = R"(
digraph parse_tree
{
  x0 [ label="root \nundefined" ]
  x0 -> { x1 }
  x1 [ label="language::declaration\nN n = 2 + 3\nundefined" ]
  x1 -> { x2, x3, x4 }
  x2 [ label="language::N_set\nN\nundefined" ]
  x3 [ label="language::name\nn\nundefined" ]
  x4 [ label="language::plus_op\nundefined" ]
  x4 -> { x5, x6 }
  x5 [ label="language::integer\n2\nundefined" ]
  x6 [ label="language::integer\n3\nundefined" ]
}
)";
  CHECK_DOT(data, result);
}
