#ifndef REF_ITEM_LIST_HPP
#define REF_ITEM_LIST_HPP

#include <Array.hpp>
#include <ItemId.hpp>
#include <RefId.hpp>

template <ItemType item_type>
class RefItemList
{
 public:
  using ItemId = ItemIdT<item_type>;

 private:
  RefId m_ref_id;
  Array<const ItemId> m_item_id_list;

 public:
  const RefId&
  refId() const
  {
    return m_ref_id;
  }

  const Array<const ItemId>&
  list() const
  {
    return m_item_id_list;
  }

  RefItemList(const RefId& ref_id, const Array<const ItemId>& item_id_list)
    : m_ref_id(ref_id), m_item_id_list(item_id_list)
  {
    ;
  }

  RefItemList& operator=(const RefItemList&) = default;
  RefItemList& operator=(RefItemList&&) = default;

  RefItemList()                   = default;
  RefItemList(const RefItemList&) = default;
  ~RefItemList()                  = default;
};

using RefNodeList = RefItemList<ItemType::node>;
using RefEdgeList = RefItemList<ItemType::edge>;
using RefFaceList = RefItemList<ItemType::face>;
using RefCellList = RefItemList<ItemType::cell>;

#endif   // REF_ITEM_LIST_HPP
