#ifndef CELL_TYPE_HPP
#define CELL_TYPE_HPP

#include <PugsMacros.hpp>
#include <string_view>

enum class CellType : unsigned short
{
  Line = 0,

  Triangle,
  Quadrangle,

  Tetrahedron,
  Pyramid,
  Prism,
  Hexahedron
};

PUGS_INLINE
std::string_view
name(const CellType& cell_type)
{
  switch (cell_type) {
  case CellType::Line:
    return "line";
  case CellType::Triangle:
    return "triangle";
  case CellType::Quadrangle:
    return "quadrangle";
  case CellType::Tetrahedron:
    return "tetrahedron";
  case CellType::Pyramid:
    return "pyramid";
  case CellType::Prism:
    return "prism";
  case CellType::Hexahedron:
    return "hexahedron";
  default:
    return "unknown cell type";
  }
}

#endif   // CELL_TYPE_HPP
