#ifndef UNARY_EXPRESSION_PROCESSOR_HPP
#define UNARY_EXPRESSION_PROCESSOR_HPP

#include <node_processor/INodeProcessor.hpp>

#include <SymbolTable.hpp>

template <typename Op>
struct UnaryOp;

template <>
struct UnaryOp<language::unary_minus>
{
  template <typename A>
  PUGS_INLINE A
  eval(const A& a)
  {
    return -a;
  }
};

template <>
struct UnaryOp<language::unary_not>
{
  template <typename A>
  PUGS_INLINE bool
  eval(const A& a)
  {
    return not a;
  }
};

template <typename UnaryOpT, typename ValueT, typename DataT>
class UnaryExpressionProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;

  PUGS_INLINE ValueT
  _eval(const ASTNodeDataVariant& a)
  {
    return UnaryOp<UnaryOpT>().eval(static_cast<ValueT>(std::get<DataT>(a)));
  }

 public:
  void
  execute(ExecUntilBreakOrContinue& exec_policy)
  {
    m_node.children[0]->execute(exec_policy);
    m_node.m_value = this->_eval(m_node.children[0]->m_value);
  }

  UnaryExpressionProcessor(ASTNode& node) : m_node{node} {}
};

#endif   // UNARY_EXPRESSION_PROCESSOR_HPP
