#ifndef INC_DEC_EXPRESSION_PROCESSOR_HPP
#define INC_DEC_EXPRESSION_PROCESSOR_HPP

#include <node_processor/INodeProcessor.hpp>

#include <SymbolTable.hpp>

template <typename Op>
struct IncDecOp;

template <>
struct IncDecOp<language::unary_minusminus>
{
  template <typename A>
  PUGS_INLINE A
  eval(A& a)
  {
    return --a;
  }
};

template <>
struct IncDecOp<language::unary_plusplus>
{
  template <typename A>
  PUGS_INLINE A
  eval(A& a)
  {
    return ++a;
  }
};

template <>
struct IncDecOp<language::post_minusminus>
{
  template <typename A>
  PUGS_INLINE A
  eval(A& a)
  {
    return a--;
  }
};

template <>
struct IncDecOp<language::post_plusplus>
{
  template <typename A>
  PUGS_INLINE A
  eval(A& a)
  {
    return a++;
  }
};

template <typename IncDecOpT, typename DataT>
class IncDecExpressionProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;
  ASTNodeDataVariant* p_value{nullptr};

 public:
  void
  execute(ExecUntilBreakOrContinue&)
  {
    m_node.m_value = IncDecOp<IncDecOpT>().eval(std::get<DataT>(*p_value));
  }

  IncDecExpressionProcessor(ASTNode& node) : m_node{node}
  {
    Assert(m_node.children[0]->is_type<language::name>());
    // It is sure at this point that children 0 is a variable name
    const std::string& symbol = m_node.children[0]->string();
    auto [i_symbol, found]    = m_node.m_symbol_table->find(symbol, m_node.children[0]->begin());
    Assert(found);
    p_value = &i_symbol->attributes().value();
  }
};

#endif   // INC_DEC_EXPRESSION_PROCESSOR_HPP
