#ifndef EXEC_UNTIL_BREAK_OR_CONTINUE_HPP
#define EXEC_UNTIL_BREAK_OR_CONTINUE_HPP

#include <PugsMacros.hpp>

struct ExecUntilBreakOrContinue
{
  enum class JumpType
  {
    no_jump,
    break_jump,
    continue_jump
  };

 private:
  JumpType m_jump_type;
  bool m_exec;

 public:
  PUGS_INLINE
  bool
  exec() const
  {
    return m_exec;
  }

  PUGS_INLINE
  JumpType
  jumpType() const
  {
    return m_jump_type;
  }

  ExecUntilBreakOrContinue& operator=(const ExecUntilBreakOrContinue&) = delete;
  ExecUntilBreakOrContinue& operator=(ExecUntilBreakOrContinue&&) = default;

  ExecUntilBreakOrContinue() : m_jump_type{JumpType::no_jump}, m_exec{true} {}

  ExecUntilBreakOrContinue(const JumpType& jump_type) : m_jump_type(jump_type), m_exec((jump_type == JumpType::no_jump))
  {
    ;
  }
};

#endif   // EXEC_UNTIL_BREAK_OR_CONTINUE_HPP
