#ifndef AFFECTATION_TO_STRING_PROCESSOR_HPP
#define AFFECTATION_TO_STRING_PROCESSOR_HPP

#include <node_processor/INodeProcessor.hpp>

#include <SymbolTable.hpp>

template <typename OperatorT, typename DataT>
class AffectationToStringProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;
  ASTNodeDataVariant* p_value{nullptr};

 public:
  void
  execute(ExecUntilBreakOrContinue& exec_policy)
  {
    m_node.children[1]->execute(exec_policy);

    if constexpr (std::is_same_v<OperatorT, language::eq_op>) {
      if constexpr (std::is_same_v<std::string, DataT>) {
        *p_value = m_node.children[1]->m_value;
      } else {
        *p_value = std::to_string(std::get<DataT>(m_node.children[1]->m_value));
      }
    } else if constexpr (std::is_same_v<OperatorT, language::pluseq_op>) {
      if constexpr (std::is_same_v<std::string, DataT>) {
        std::get<std::string>(*p_value) += std::get<std::string>(m_node.children[1]->m_value);
      } else {
        std::get<std::string>(*p_value) += std::to_string(std::get<DataT>(m_node.children[1]->m_value));
      }
    }
  }

  AffectationToStringProcessor(ASTNode& node) : m_node{node}
  {
    const std::string& symbol = m_node.children[0]->string();
    auto [i_symbol, found]    = m_node.m_symbol_table->find(symbol, m_node.children[0]->begin());
    Assert(found);
    p_value = &i_symbol->attributes().value();
  }
};

#endif   // AFFECTATION_TO_STRING_PROCESSOR_HPP
