#ifndef CMATH_MODULE_HPP
#define CMATH_MODULE_HPP

#include <PugsMacros.hpp>

#include <memory>
#include <string>
#include <unordered_map>

class ICFunctionEmbedder;
class CMathModule
{
 private:
  std::unordered_map<std::string, std::shared_ptr<ICFunctionEmbedder>> m_name_cfunction_map;

  void _addFunction(const std::string& name, std::shared_ptr<ICFunctionEmbedder> c_function_embedder);

 public:
  const auto&
  getNameCFunctionsMap() const
  {
    return m_name_cfunction_map;
  }

  CMathModule();

  ~CMathModule() = default;
};

#endif   // CMATH_MODULE_HPP
