#include <CMathModule.hpp>

#include <CFunctionEmbedder.hpp>

#include <iostream>

void
CMathModule::_addFunction(const std::string& name, std::shared_ptr<ICFunctionEmbedder> c_function_embedder)
{
  auto [i_function, success] = m_name_cfunction_map.insert(std::make_pair(name, c_function_embedder));
  // LCOV_EXCL_START
  if (not success) {
    std::cerr << "function " << name << " cannot be add!\n";
    std::exit(1);
  }
  // LCOV_EXCL_STOP
}

CMathModule::CMathModule()
{
  this->_addFunction("sqrt", std::make_shared<CFunctionEmbedder<double, double>>(
                               std::function<double(double)>{[](double x) -> double { return std::sqrt(x); }}));

  this->_addFunction("abs", std::make_shared<CFunctionEmbedder<double, double>>(
                              std::function<double(double)>{[](double x) -> double { return std::abs(x); }}));

  this->_addFunction("sin", std::make_shared<CFunctionEmbedder<double, double>>(
                              std::function<double(double)>{[](double x) -> double { return std::sin(x); }}));

  this->_addFunction("cos", std::make_shared<CFunctionEmbedder<double, double>>(
                              std::function<double(double)>{[](double x) -> double { return std::cos(x); }}));

  this->_addFunction("tan", std::make_shared<CFunctionEmbedder<double, double>>(
                              std::function<double(double)>{[](double x) -> double { return std::tan(x); }}));

  this->_addFunction("asin", std::make_shared<CFunctionEmbedder<double, double>>(
                               std::function<double(double)>{[](double x) -> double { return std::asin(x); }}));

  this->_addFunction("acos", std::make_shared<CFunctionEmbedder<double, double>>(
                               std::function<double(double)>{[](double x) -> double { return std::acos(x); }}));

  this->_addFunction("atan", std::make_shared<CFunctionEmbedder<double, double>>(
                               std::function<double(double)>{[](double x) -> double { return std::atan(x); }}));

  this->_addFunction("atan2",
                     std::make_shared<CFunctionEmbedder<double, double, double>>(std::function<double(double, double)>{
                       [](double x, double y) -> double { return std::atan2(x, y); }}));

  this->_addFunction("sinh", std::make_shared<CFunctionEmbedder<double, double>>(
                               std::function<double(double)>{[](double x) -> double { return std::sinh(x); }}));

  this->_addFunction("cosh", std::make_shared<CFunctionEmbedder<double, double>>(
                               std::function<double(double)>{[](double x) -> double { return std::cosh(x); }}));

  this->_addFunction("tanh", std::make_shared<CFunctionEmbedder<double, double>>(
                               std::function<double(double)>{[](double x) -> double { return std::tanh(x); }}));

  this->_addFunction("asinh", std::make_shared<CFunctionEmbedder<double, double>>(
                                std::function<double(double)>{[](double x) -> double { return std::asinh(x); }}));

  this->_addFunction("acosh", std::make_shared<CFunctionEmbedder<double, double>>(
                                std::function<double(double)>{[](double x) -> double { return std::acosh(x); }}));

  this->_addFunction("atanh", std::make_shared<CFunctionEmbedder<double, double>>(
                                std::function<double(double)>{[](double x) -> double { return std::atanh(x); }}));

  this->_addFunction("exp", std::make_shared<CFunctionEmbedder<double, double>>(
                              std::function<double(double)>{[](double x) -> double { return std::exp(x); }}));

  this->_addFunction("log", std::make_shared<CFunctionEmbedder<double, double>>(
                              std::function<double(double)>{[](double x) -> double { return std::log(x); }}));

  this->_addFunction("pow",
                     std::make_shared<CFunctionEmbedder<double, double, double>>(std::function<double(double, double)>{
                       [](double x, double y) -> double { return std::pow(x, y); }}));

  this->_addFunction("nearbyint", std::make_shared<CFunctionEmbedder<double, double>>(std::function<double(double)>{
                                    [](double x) -> double { return std::nearbyint(x); }}));

  this->_addFunction("ceil", std::make_shared<CFunctionEmbedder<double, double>>(
                               std::function<double(double)>{[](double x) -> double { return std::ceil(x); }}));

  this->_addFunction("floor", std::make_shared<CFunctionEmbedder<double, double>>(
                                std::function<double(double)>{[](double x) -> double { return std::floor(x); }}));

  this->_addFunction("trunc", std::make_shared<CFunctionEmbedder<double, double>>(
                                std::function<double(double)>{[](double x) -> double { return std::trunc(x); }}));

  this->_addFunction("round", std::make_shared<CFunctionEmbedder<double, double>>(
                                std::function<double(double)>{[](double x) -> double { return std::round(x); }}));

  this->_addFunction("lround", std::make_shared<CFunctionEmbedder<int64_t, double>>(
                                 std::function<int64_t(double)>{[](double x) -> int64_t { return std::lround(x); }}));

  this->_addFunction("rint", std::make_shared<CFunctionEmbedder<double, double>>(
                               std::function<double(double)>{[](double x) -> double { return std::rint(x); }}));

  this->_addFunction("lrint", std::make_shared<CFunctionEmbedder<int64_t, double>>(
                                std::function<int64_t(double)>{[](double x) -> int64_t { return std::lrint(x); }}));
}
