#ifndef CFUNCTION_EMBEDDER_TABLE_HPP
#define CFUNCTION_EMBEDDER_TABLE_HPP

#include <PugsAssert.hpp>

#include <memory>
#include <vector>

class ICFunctionEmbedder;
class CFunctionEmbedderTable
{
 private:
  std::vector<std::shared_ptr<ICFunctionEmbedder>> m_c_function_embedder_list;

 public:
  PUGS_INLINE
  size_t
  size() const
  {
    return m_c_function_embedder_list.size();
  }

  PUGS_INLINE
  const std::shared_ptr<ICFunctionEmbedder>& operator[](size_t function_id) const
  {
    Assert(function_id < m_c_function_embedder_list.size());
    return m_c_function_embedder_list[function_id];
  }

  void
  add(std::shared_ptr<ICFunctionEmbedder> c_function_embedder)
  {
    m_c_function_embedder_list.push_back(c_function_embedder);
  }

  CFunctionEmbedderTable()  = default;
  ~CFunctionEmbedderTable() = default;
};

#endif   // CFUNCTION_EMBEDDER_TABLE_HPP
