#include <ASTNodeValueBuilder.hpp>

#include <PEGGrammar.hpp>
#include <PugsAssert.hpp>

#include <EscapedString.hpp>

#include <FunctionTable.hpp>
#include <SymbolTable.hpp>

void
ASTNodeValueBuilder::_buildNodeValue(ASTNode& n)
{
  if (n.is_type<language::block>()) {
    if (!n.children.empty()) {
      for (auto& child : n.children) {
        this->_buildNodeValue(*child);
      }
    }
    n.m_data_type = ASTNodeDataType::void_t;
  } else {
    for (auto& child : n.children) {
      this->_buildNodeValue(*child);
    }

    if (n.has_content()) {
      if (n.is_type<language::real>()) {
        std::stringstream ss(n.string());
        double v;
        ss >> v;
        n.m_value = v;
      } else if (n.is_type<language::integer>()) {
        std::stringstream ss(n.string());
        int64_t v;
        ss >> v;
        n.m_value = v;
      } else if (n.is_type<language::literal>()) {
        n.m_value = unescapeString(n.string());
      } else if (n.is_type<language::for_test>()) {
        // if AST contains a for_test statement, it means that no test were
        // given to the for-loop, so its value is always true
        n.m_value = true;
      } else if (n.is_type<language::true_kw>()) {
        n.m_value = true;
      } else if (n.is_type<language::false_kw>()) {
        n.m_value = false;
      }
    }
  }
}

ASTNodeValueBuilder::ASTNodeValueBuilder(ASTNode& node)
{
  Assert(node.is_root());
  node.m_data_type = ASTNodeDataType::void_t;
  this->_buildNodeValue(node);

  FunctionTable& function_table = node.m_symbol_table->functionTable();
  for (size_t function_id = 0; function_id < function_table.size(); ++function_id) {
    FunctionDescriptor& function_descriptor = function_table[function_id];
    ASTNode& function_expression            = function_descriptor.definitionNode();

    this->_buildNodeValue(function_expression);
  }

  std::cout << " - build node values\n";
}
