#include <ASTNodeIncDecExpressionBuilder.hpp>
#include <PEGGrammar.hpp>

#include <node_processor/IncDecExpressionProcessor.hpp>

ASTNodeIncDecExpressionBuilder::ASTNodeIncDecExpressionBuilder(ASTNode& n)
{
  auto set_inc_dec_operator_processor = [](ASTNode& n, const auto& operator_v) {
    auto set_inc_dec_processor_for_value = [&](const ASTNodeDataType& data_type) {
      using OperatorT = std::decay_t<decltype(operator_v)>;
      switch (data_type) {
      case ASTNodeDataType::unsigned_int_t: {
        n.m_node_processor = std::make_unique<IncDecExpressionProcessor<OperatorT, uint64_t>>(n);
        break;
      }
      case ASTNodeDataType::int_t: {
        n.m_node_processor = std::make_unique<IncDecExpressionProcessor<OperatorT, int64_t>>(n);
        break;
      }
      case ASTNodeDataType::double_t: {
        n.m_node_processor = std::make_unique<IncDecExpressionProcessor<OperatorT, double>>(n);
        break;
      }
      default: {
        throw parse_error("unexpected error: undefined data type for unary operator", std::vector{n.begin()});
      }
      }
    };

    if (not n.children[0]->is_type<language::name>()) {
      if (n.children[0]->is_type<language::post_minusminus>() or n.children[0]->is_type<language::post_plusplus>() or
          n.children[0]->is_type<language::unary_minusminus>() or n.children[0]->is_type<language::unary_plusplus>()) {
        throw parse_error("chaining ++ or -- operators is not allowed", std::vector{n.children[0]->begin()});
      } else {
        throw parse_error("invalid operand type for unary operator", std::vector{n.children[0]->begin()});
      }
    }

    set_inc_dec_processor_for_value(n.m_data_type);
  };

  if (n.is_type<language::unary_minusminus>()) {
    set_inc_dec_operator_processor(n, language::unary_minusminus{});
  } else if (n.is_type<language::unary_plusplus>()) {
    set_inc_dec_operator_processor(n, language::unary_plusplus{});
  } else if (n.is_type<language::post_minusminus>()) {
    set_inc_dec_operator_processor(n, language::post_minusminus{});
  } else if (n.is_type<language::post_plusplus>()) {
    set_inc_dec_operator_processor(n, language::post_plusplus{});
  } else {
    throw parse_error("unexpected error: undefined increment/decrement operator", std::vector{n.begin()});
  }
}
