#ifndef AST_NODE_FUNCTION_EXPRESSION_BUILDER_HPP
#define AST_NODE_FUNCTION_EXPRESSION_BUILDER_HPP

#include <ASTNode.hpp>
#include <node_processor/INodeProcessor.hpp>

class FunctionProcessor;
class FunctionDescriptor;

class ASTNodeFunctionExpressionBuilder
{
 private:
  template <typename SymbolType>
  PUGS_INLINE std::unique_ptr<INodeProcessor> _getArgumentProcessor(ASTNode& argument_node,
                                                                    SymbolType& parameter_symbol);

  PUGS_INLINE
  void _storeArgumentProcessor(ASTNode& parameter_variable,
                               ASTNode& argument_node,
                               FunctionProcessor& function_processor);

  PUGS_INLINE
  void _buildArgumentProcessors(FunctionDescriptor& function_descriptor,
                                ASTNode& node,
                                FunctionProcessor& function_processor);

  PUGS_INLINE
  std::unique_ptr<INodeProcessor> _getFunctionProcessor(const ASTNodeDataType expression_value_type,
                                                        const ASTNodeDataType return_value_type,
                                                        ASTNode& node);

 public:
  ASTNodeFunctionExpressionBuilder(ASTNode& node);
};

#endif   // AST_NODE_FUNCTION_EXPRESSION_BUILDER_HPP
