#include <ASTNodeFunctionEvaluationExpressionBuilder.hpp>

#include <ASTNodeCFunctionExpressionBuilder.hpp>
#include <ASTNodeFunctionExpressionBuilder.hpp>

#include <SymbolTable.hpp>

ASTNodeFunctionEvaluationExpressionBuilder::ASTNodeFunctionEvaluationExpressionBuilder(ASTNode& node)
{
  auto [i_function_symbol, found] = node.m_symbol_table->find(node.children[0]->string(), node.begin());
  Assert(found);

  switch (i_function_symbol->attributes().dataType()) {
  case ASTNodeDataType::function_t: {
    ASTNodeFunctionExpressionBuilder{node};
    break;
  }
  case ASTNodeDataType::c_function_t: {
    ASTNodeCFunctionExpressionBuilder{node};
    break;
  }
    //    LCOV_EXCL_START
  default: {
    throw parse_error("unexpected function type", node.begin());
  }
    //    LCOV_EXCL_STOP
  }
}
