#ifndef AST_NODE_DATA_TYPE_HPP
#define AST_NODE_DATA_TYPE_HPP

#include <limits>
#include <string>

enum class ASTNodeDataType : int32_t
{
  undefined_t    = -1,
  bool_t         = 0,
  int_t          = 1,
  unsigned_int_t = 2,
  double_t       = 3,
  string_t       = 5,
  typename_t     = 10,
  function_t     = 11,
  c_function_t   = 12,
  void_t         = std::numeric_limits<int32_t>::max()
};

std::string dataTypeName(const ASTNodeDataType& data_type);

ASTNodeDataType dataTypePromotion(const ASTNodeDataType& data_type_1, const ASTNodeDataType& data_type_2);

// Traits ast_node_data_type_from_pod

template <typename T>
inline constexpr ASTNodeDataType ast_node_data_type_from_pod = ASTNodeDataType::undefined_t;

template <>
inline constexpr ASTNodeDataType ast_node_data_type_from_pod<bool> = ASTNodeDataType::bool_t;
template <>
inline constexpr ASTNodeDataType ast_node_data_type_from_pod<int64_t> = ASTNodeDataType::int_t;
template <>
inline constexpr ASTNodeDataType ast_node_data_type_from_pod<uint64_t> = ASTNodeDataType::unsigned_int_t;
template <>
inline constexpr ASTNodeDataType ast_node_data_type_from_pod<double> = ASTNodeDataType::double_t;

#endif   // AST_NODE_DATA_TYPE_HPP
