#ifndef AST_NODE_C_FUNCTION_EXPRESSION_BUILDER_HPP
#define AST_NODE_C_FUNCTION_EXPRESSION_BUILDER_HPP

#include <ASTNode.hpp>
#include <node_processor/INodeProcessor.hpp>

class CFunctionProcessor;

class ASTNodeCFunctionExpressionBuilder
{
 private:
  PUGS_INLINE std::unique_ptr<INodeProcessor> _getArgumentProcessor(ASTNode& argument_node,
                                                                    const ASTNodeDataType& argument_type,
                                                                    ASTNodeDataVariant& argument_value);

  PUGS_INLINE
  void _storeArgumentProcessor(const size_t argument_number,
                               ASTNode& argument_node,
                               const std::vector<ASTNodeDataType>& argument_type_list,
                               CFunctionProcessor& c_function_processor);

  PUGS_INLINE
  void _buildArgumentProcessors(ASTNode& node,
                                const std::vector<ASTNodeDataType>& argument_type_list,
                                CFunctionProcessor& c_function_processor);

 public:
  ASTNodeCFunctionExpressionBuilder(ASTNode& node);
};

#endif   // AST_NODE_C_FUNCTION_EXPRESSION_BUILDER_HPP
