#include <ASTModulesImporter.hpp>

#include <ASTSymbolTableBuilder.hpp>
#include <SymbolTable.hpp>

#include <PEGGrammar.hpp>

#include <CFunctionEmbedder.hpp>
#include <CMathModule.hpp>

#include <memory>

void
ASTModulesImporter::_importModule(ASTNode& import_node)
{
  Assert(import_node.is_type<language::import_instruction>());
  Assert(import_node.children[0]->is_type<language::module_name>());

  ASTNode& module_name_node     = *import_node.children[0];
  const std::string module_name = module_name_node.string();

  if (auto [i_module_name, success] = m_imported_modules.insert(module_name); not success) {
    std::cout << " * ignoring  '" << rang::fgB::green << module_name << rang::style::reset
              << "' module, already imported\n";
    return;
  }

  std::cout << " * importing '" << rang::fgB::green << module_name << rang::style::reset << "' module\n";

  if (module_name == "math") {
    CMathModule math_module;

    CFunctionEmbedderTable& c_function_embedder_table = m_symbol_table.cFunctionEbedderTable();

    for (auto [symbol_name, c_function] : math_module.getNameCFunctionsMap()) {
      auto [i_symbol, success] = m_symbol_table.add(symbol_name, import_node.begin());

      if (not success) {
        std::ostringstream error_message;
        error_message << "cannot add symbol '" << symbol_name << "' it is already defined";
        throw parse_error(error_message.str(), import_node.begin());
      }

      i_symbol->attributes().setDataType(ASTNodeDataType::c_function_t);
      i_symbol->attributes().setIsInitialized();
      i_symbol->attributes().value() = c_function_embedder_table.size();

      c_function_embedder_table.add(c_function);
    }
  } else {
    throw parse_error(std::string{"could not find module "} + module_name, std::vector{module_name_node.begin()});
  }
}

void
ASTModulesImporter::_importAllModules(ASTNode& node)
{
  if (node.is_type<language::import_instruction>()) {
    this->_importModule(node);
  } else {
    for (auto& child : node.children) {
      this->_importAllModules(*child);
    }
  }
}

ASTModulesImporter::ASTModulesImporter(ASTNode& root_node) : m_symbol_table{*root_node.m_symbol_table}
{
  Assert(root_node.is_root());
  this->_importAllModules(root_node);
  std::cout << " - loaded modules\n";
}
