# -----------------------------------------------------------------
#       Let Kokkos do the job and find good compilier flags
# -----------------------------------------------------------------

#
# This file is slightly adapted from Trilinos build system
# (https://trilinos.org/)
#

set(KOKKOS_SRC_PATH ${Kokkos_SOURCE_DIR})
set(KOKKOS_PATH ${KOKKOS_SRC_PATH})
set(Kokkos_GEN_DIR ${CMAKE_BINARY_DIR})

set_kokkos_cxx_compiler()
set_kokkos_cxx_standard()

include(${KOKKOS_SRC_PATH}/cmake/kokkos_options.cmake)

#------------ COMPUTE KOKKOS_SETTINGS ----------------------------------------
include(${KOKKOS_SRC_PATH}/cmake/kokkos_settings.cmake)

#------------ GENERATE HEADER AND SOURCE FILES -------------------------------
execute_process(
  COMMAND ${KOKKOS_SETTINGS} make -f ${KOKKOS_SRC_PATH}/cmake/Makefile.generate_cmake_settings CXX=${CMAKE_CXX_COMPILER} generate_build_settings
  WORKING_DIRECTORY "${Kokkos_GEN_DIR}"
  OUTPUT_FILE ${Kokkos_GEN_DIR}/core_src_make.out
  RESULT_VARIABLE GEN_SETTINGS_RESULT
  )

if (GEN_SETTINGS_RESULT)
  message(FATAL_ERROR "Kokkos settings generation failed:\n"
    "${KOKKOS_SETTINGS} make -f ${KOKKOS_SRC_PATH}/cmake/Makefile.generate_cmake_settings CXX=${CMAKE_CXX_COMPILER} generate_build_settings")
endif()

include(${Kokkos_GEN_DIR}/kokkos_generated_settings.cmake)

#------------ GET KOKKOS COMPILER OPTIONS ------------------------------------

set(CMAKE_CXX_FLAGSl "")
foreach(opt ${KOKKOS_CXX_FLAGS})
  set(CMAKE_CXX_FLAGSl "${CMAKE_CXX_FLAGSl} ${opt}")
endforeach()
set(CMAKE_CXX_FLAGS "${CMAKE_CXX_FLAGS} ${CMAKE_CXX_FLAGSl}")
