#ifndef REF_ID_HPP
#define REF_ID_HPP

#include <string>
#include <iostream>

class RefId
{
 private:
  unsigned int m_tag_number;
  std::string m_tag_name;

 public:
  friend std::ostream& operator<<(std::ostream& os, const RefId& ref_id)
  {
    if (ref_id.m_tag_name.size()>0) {
      os << ref_id.m_tag_name << '(' << ref_id.m_tag_number << ')';
    } else {
      os << ref_id.m_tag_number;
    }
    return os;
  }

  bool operator==(const RefId& ref_id) const
  {
    return ((m_tag_number==ref_id.m_tag_number) and
            (m_tag_name==ref_id.m_tag_name));
  }

  bool operator<(const RefId& ref_id) const
  {
    return ((m_tag_number<ref_id.m_tag_number) or
            ((m_tag_number==ref_id.m_tag_number) and
             (m_tag_name<ref_id.m_tag_name)));
  }

  const unsigned int& tagNumber() const
  {
    return m_tag_number;
  }

  const std::string& tagName() const
  {
    return m_tag_name;
  }

  RefId& operator=(const RefId&) = default;
  RefId& operator=(RefId&&) = default;
  RefId() = default;
  RefId(const RefId&) = default;
  RefId(RefId&&) = default;
  explicit RefId(const unsigned int& tag_number,
                 const std::string& tag_name)
      : m_tag_number(tag_number),
        m_tag_name(tag_name)
  {
    ;
  }

  explicit RefId(const unsigned int& tag_number)
      : m_tag_number(tag_number)
  {
    ;
  }

  ~RefId() = default;
};

#endif // REF_ID_HPP
