#ifndef EIGENVALUE_SOLVER_HPP
#define EIGENVALUE_SOLVER_HPP

#include <algebra/PETScUtils.hpp>

#include <algebra/DenseMatrix.hpp>
#include <algebra/Vector.hpp>
#include <utils/Array.hpp>
#include <utils/Exceptions.hpp>

class EigenvalueSolver
{
 private:
  struct Internals;

#ifdef PUGS_HAS_SLEPC
  void computeForSymmetricMatrix(const PETScAijMatrixEmbedder& A, Array<double>& eigenvalues);

  void computeForSymmetricMatrix(const PETScAijMatrixEmbedder& A,
                                 Array<double>& eigenvalues,
                                 std::vector<Vector<double>>& eigenvectors);

  void computeForSymmetricMatrix(const PETScAijMatrixEmbedder& A, Array<double>& eigenvalues, DenseMatrix<double>& P);
#endif   // PUGS_HAS_SLEPC

 public:
  template <typename MatrixType>
  void
  computeForSymmetricMatrix([[maybe_unused]] const MatrixType& A, [[maybe_unused]] Array<double>& eigenvalues)
  {
#ifdef PUGS_HAS_SLEPC
    this->computeForSymmetricMatrix(PETScAijMatrixEmbedder{A}, eigenvalues);
#else    // PUGS_HAS_SLEPC
    throw NotImplementedError("SLEPc is required to solve eigenvalue problems");
#endif   // PUGS_HAS_SLEPC
  }

  template <typename MatrixType>
  void
  computeForSymmetricMatrix([[maybe_unused]] const MatrixType& A,
                            [[maybe_unused]] Array<double>& eigenvalues,
                            [[maybe_unused]] std::vector<Vector<double>>& eigenvectors)
  {
#ifdef PUGS_HAS_SLEPC
    this->computeForSymmetricMatrix(PETScAijMatrixEmbedder{A}, eigenvalues, eigenvectors);
#else    // PUGS_HAS_SLEPC
    throw NotImplementedError("SLEPc is required to solve eigenvalue problems");
#endif   // PUGS_HAS_SLEPC
  }

  template <typename MatrixType>
  void
  computeForSymmetricMatrix([[maybe_unused]] const MatrixType& A,
                            [[maybe_unused]] Array<double>& eigenvalues,
                            [[maybe_unused]] DenseMatrix<double>& P)
  {
#ifdef PUGS_HAS_SLEPC
    this->computeForSymmetricMatrix(PETScAijMatrixEmbedder{A}, eigenvalues, P);
#else    // PUGS_HAS_SLEPC
    throw NotImplementedError("SLEPc is required to solve eigenvalue problems");
#endif   // PUGS_HAS_SLEPC
  }

  EigenvalueSolver();
  ~EigenvalueSolver() = default;
};

#endif   // EIGENVALUE_SOLVER_HPP
