#ifndef I_NODE_PROCESSOR_HPP
#define I_NODE_PROCESSOR_HPP

#include <Demangle.hpp>
#include <node_processor/ExecUntilBreakOrContinue.hpp>

#include <string>
#include <typeinfo>

struct INodeProcessor
{
  virtual void execute(ExecUntilBreakOrContinue& exec_policy) = 0;

  std::string
  typeIdName() const
  {
    return demangle(typeid(*this).name());
  }

  INodeProcessor(const INodeProcessor&) = delete;

  INodeProcessor() = default;

  virtual ~INodeProcessor() = default;
};

#endif   // I_NODE_PROCESSOR_HPP
