#ifndef FOR_PROCESSOR_HPP
#define FOR_PROCESSOR_HPP

#include <node_processor/INodeProcessor.hpp>

class ForProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;

 public:
  void
  execute(ExecUntilBreakOrContinue& exec_policy)
  {
    ExecUntilBreakOrContinue exec_until_jump;
    m_node.children[0]->execute(exec_policy);
    while ([&]() {
      m_node.children[1]->execute(exec_policy);
      return static_cast<bool>(std::visit(
        [](const auto& value) -> bool {
          using T = std::decay_t<decltype(value)>;
          if constexpr (std::is_arithmetic_v<T>) {
            return value;
          } else {
            return false;   // LCOV_EXCL_LINE (unreachable: only there for compilation purpose)
          }
        },
        m_node.children[1]->m_value));
    }()) {
      m_node.children[3]->execute(exec_until_jump);
      if (not exec_until_jump.exec()) {
        if (exec_until_jump.jumpType() == ExecUntilBreakOrContinue::JumpType::break_jump) {
          break;
        } else if (exec_until_jump.jumpType() == ExecUntilBreakOrContinue::JumpType::continue_jump) {
          exec_until_jump = ExecUntilBreakOrContinue{};   // getting ready for next loop traversal
        }
      }

      m_node.children[2]->execute(exec_policy);
    }
  }

  ForProcessor(ASTNode& node) : m_node{node} {}
};

#endif   // FOR_PROCESSOR_HPP
