#ifndef DO_WHILE_PROCESSOR_HPP
#define DO_WHILE_PROCESSOR_HPP

#include <node_processor/INodeProcessor.hpp>

class DoWhileProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;

 public:
  void
  execute(ExecUntilBreakOrContinue& exec_policy)
  {
    bool continuation_test = true;
    ExecUntilBreakOrContinue exec_until_jump;
    do {
      m_node.children[0]->execute(exec_until_jump);
      if (not exec_until_jump.exec()) {
        if (exec_until_jump.jumpType() == ExecUntilBreakOrContinue::JumpType::break_jump) {
          break;
        } else if (exec_until_jump.jumpType() == ExecUntilBreakOrContinue::JumpType::continue_jump) {
          exec_until_jump = ExecUntilBreakOrContinue{};   // getting ready for next loop traversal
        }
      }
      m_node.children[1]->execute(exec_policy);
      continuation_test = static_cast<bool>(std::visit(
        [](const auto& value) -> bool {
          using T = std::decay_t<decltype(value)>;
          if constexpr (std::is_arithmetic_v<T>) {
            return value;
          } else {
            return false;   // LCOV_EXCL_LINE (unreachable: only there for compilation purpose)
          }
        },
        m_node.children[1]->m_value));
    } while (continuation_test);
  }

  DoWhileProcessor(ASTNode& node) : m_node{node} {}
};

#endif   // DO_WHILE_PROCESSOR_HPP
