#ifndef CONCAT_EXPRESSION_PROCESSOR_HPP
#define CONCAT_EXPRESSION_PROCESSOR_HPP

#include <node_processor/INodeProcessor.hpp>

template <typename B_DataT>
class ConcatExpressionProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;

  PUGS_INLINE void
  _eval(const std::string& a, const ASTNodeDataVariant& b, ASTNodeDataVariant& value)
  {
    if constexpr (std::is_same_v<B_DataT, std::string>) {
      value = a + std::get<B_DataT>(b);
    } else {
      value = a + std::to_string(std::get<B_DataT>(b));
    }
  }

 public:
  void
  execute(ExecUntilBreakOrContinue& exec_policy)
  {
    m_node.children[0]->execute(exec_policy);
    m_node.children[1]->execute(exec_policy);

    this->_eval(std::get<std::string>(m_node.children[0]->m_value), m_node.children[1]->m_value, m_node.m_value);
  }

  ConcatExpressionProcessor(ASTNode& node) : m_node{node} {}
};

#endif   // CONCAT_EXPRESSION_PROCESSOR_HPP
