#ifndef AFFECTATION_PROCESSOR_HPP
#define AFFECTATION_PROCESSOR_HPP

#include <node_processor/INodeProcessor.hpp>

#include <SymbolTable.hpp>

template <typename Op>
struct AffOp;

template <>
struct AffOp<language::multiplyeq_op>
{
  template <typename A, typename B>
  PUGS_INLINE void
  eval(A& a, const B& b)
  {
    a *= b;
  }
};

template <>
struct AffOp<language::divideeq_op>
{
  template <typename A, typename B>
  PUGS_INLINE void
  eval(A& a, const B& b)
  {
    a /= b;
  }
};

template <>
struct AffOp<language::pluseq_op>
{
  template <typename A, typename B>
  PUGS_INLINE void
  eval(A& a, const B& b)
  {
    a += b;
  }
};

template <>
struct AffOp<language::minuseq_op>
{
  template <typename A, typename B>
  PUGS_INLINE void
  eval(A& a, const B& b)
  {
    a -= b;
  }
};

template <typename OperatorT, typename ValueT, typename DataT>
class AffectationProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;
  ASTNodeDataVariant* p_value{nullptr};

  static inline const bool _is_defined{[] {
    if constexpr (std::is_same_v<std::decay_t<ValueT>, bool>) {
      if constexpr (not std::is_same_v<OperatorT, language::eq_op>) {
        return false;
      }
    }
    return true;
  }()};

 public:
  void
  execute(ExecUntilBreakOrContinue& exec_policy)
  {
    if constexpr (_is_defined) {
      m_node.children[1]->execute(exec_policy);

      if constexpr (std::is_same_v<OperatorT, language::eq_op>) {
        if constexpr (std::is_same_v<ValueT, DataT>) {
          *p_value = m_node.children[1]->m_value;
        } else {
          *p_value = static_cast<ValueT>(std::get<DataT>(m_node.children[1]->m_value));
        }
      } else {
        AffOp<OperatorT>().eval(std::get<ValueT>(*p_value), std::get<DataT>(m_node.children[1]->m_value));
      }
    }
  }

  AffectationProcessor(ASTNode& node) : m_node{node}
  {
    if constexpr (_is_defined) {
      const std::string& symbol = m_node.children[0]->string();
      auto [i_symbol, found]    = m_node.m_symbol_table->find(symbol, m_node.children[0]->begin());
      Assert(found);
      p_value = &i_symbol->attributes().value();
    } else {
      throw parse_error("invalid operands to affectation expression", std::vector{m_node.begin()});
    }
  }
};

#endif   // AFFECTATION_PROCESSOR_HPP
