#ifndef AST_NODE_LIST_PROCESSOR_HPP
#define AST_NODE_LIST_PROCESSOR_HPP

#include <node_processor/INodeProcessor.hpp>

class ASTNodeListProcessor final : public INodeProcessor
{
 private:
  ASTNode& m_node;

 public:
  void
  execute(ExecUntilBreakOrContinue& exec_policy)
  {
    for (auto& child : m_node.children) {
      child->execute(exec_policy);
    }
  }

  ASTNodeListProcessor(ASTNode& node) : m_node{node} {}
};

#endif   // AST_NODE_LIST_PROCESSOR_HPP
