#include <ASTNodeDeclarationCleaner.hpp>

#include <PEGGrammar.hpp>
#include <PugsAssert.hpp>

#include <stack>

void
ASTNodeDeclarationCleaner::_removeDeclarationNode(ASTNode& n)
{
  std::stack<size_t> declaration_ids;
  for (size_t i_child = 0; i_child < n.children.size(); ++i_child) {
    if (n.children[i_child]->is<language::declaration>() or n.children[i_child]->is<language::let_declaration>()) {
      declaration_ids.push(i_child);
    }
  }

  while (declaration_ids.size() > 0) {
    size_t i_removed = declaration_ids.top();
    declaration_ids.pop();
    for (size_t i = i_removed; i + 1 < n.children.size(); ++i) {
      n.children[i] = std::move(n.children[i + 1]);
    }
    n.children.pop_back();
  }

  for (auto& child : n.children) {
    this->_removeDeclarationNode(*child);
  }
}

ASTNodeDeclarationCleaner::ASTNodeDeclarationCleaner(ASTNode& n)
{
  Assert(n.is_root());
  this->_removeDeclarationNode(n);
}
