#include <ASTNodeDataType.hpp>

std::string
dataTypeName(const ASTNodeDataType& data_type)
{
  std::string name;
  switch (data_type) {
  case ASTNodeDataType::undefined_t:
    name = "undefined";
    break;
  case ASTNodeDataType::bool_t:
    name = "B";
    break;
  case ASTNodeDataType::unsigned_int_t:
    name = "N";
    break;
  case ASTNodeDataType::int_t:
    name = "Z";
    break;
  case ASTNodeDataType::double_t:
    name = "R";
    break;
  case ASTNodeDataType::string_t:
    name = "string";
    break;
  case ASTNodeDataType::typename_t:
    name = "typename";
    break;
  case ASTNodeDataType::function_t:
    name = "function";
    break;
  case ASTNodeDataType::void_t:
    name = "void";
    break;
  }
  return name;
}

ASTNodeDataType
dataTypePromotion(const ASTNodeDataType& data_type_1, const ASTNodeDataType& data_type_2)
{
  if (data_type_1 == data_type_2) {
    return data_type_1;
  } else if ((std::max(data_type_1, data_type_2) <= ASTNodeDataType::double_t) and
             (std::min(data_type_1, data_type_2) >= ASTNodeDataType::bool_t)) {
    return std::max(data_type_1, data_type_2);
  } else if ((data_type_1 == ASTNodeDataType::string_t) and (data_type_2 <= ASTNodeDataType::double_t) and
             (data_type_2 >= ASTNodeDataType::bool_t)) {
    return data_type_1;
  } else {
    return ASTNodeDataType::undefined_t;
  }
}
