#ifndef AST_NODE_HPP
#define AST_NODE_HPP

#include <PugsAssert.hpp>
#include <PugsMacros.hpp>

#include <ASTNodeDataType.hpp>
#include <ASTNodeDataVariant.hpp>

#include <node_processor/ExecUntilBreakOrContinue.hpp>
#include <node_processor/INodeProcessor.hpp>

#include <pegtl/contrib/parse_tree.hpp>

using namespace TAO_PEGTL_NAMESPACE;

class SymbolTable;

struct ASTNode : public parse_tree::basic_node<ASTNode>
{
  std::shared_ptr<SymbolTable> m_symbol_table;
  std::unique_ptr<INodeProcessor> m_node_processor;

  ASTNodeDataType m_data_type{ASTNodeDataType::undefined_t};
  ASTNodeDataVariant m_value;

  PUGS_INLINE
  void
  execute(ExecUntilBreakOrContinue& exec_policy)
  {
    Assert(m_node_processor, "Undefined node processor");
    if (exec_policy.exec()) {
      m_node_processor->execute(exec_policy);
    }
  }
};

#endif   // AST_NODE_HPP
