#ifndef AST_BUILDER_HPP
#define AST_BUILDER_HPP

#include <ASTNode.hpp>
#include <pegtl.hpp>

struct ASTBuilder
{
 private:
  struct rearrange;
  struct simplify_unary;
  struct simplify_statement_block;
  struct simplify_for_statement_block;
  struct simplify_for_init;
  struct simplify_for_test;
  struct simplify_for_post;
  struct simplify_stream_statement;

 public:
  template <typename InputT>
  static std::unique_ptr<ASTNode> build(InputT& input);
};

#endif   // AST_BUILDER_HPP
