#ifndef BLOCK_PERFECTGAS_HPP
#define BLOCK_PERFECTGAS_HPP

struct BlockPerfectGas
{
private:
  Kokkos::View<double*> m_rhoj;
  Kokkos::View<double*> m_ej;
  Kokkos::View<double*> m_pj;
  Kokkos::View<double*> m_gammaj;
  Kokkos::View<double*> m_cj;

public:
  BlockPerfectGas(Kokkos::View<double*> rhoj,
		 Kokkos::View<double*> ej,
		 Kokkos::View<double*> pj,
		 Kokkos::View<double*> gammaj,
		 Kokkos::View<double*> cj)
    : m_rhoj(rhoj),
      m_ej(ej),
      m_pj(pj),
      m_gammaj(gammaj),
      m_cj(cj)
  {
    ;
  }

  void updatePandCFromRhoE()
  {
    const int nj = m_ej.size();
    const Kokkos::View<const double*> rho = m_rhoj;
    const Kokkos::View<const double*> e = m_ej;
    const Kokkos::View<const double*> gamma = m_gammaj;

    Kokkos::parallel_for(nj, KOKKOS_LAMBDA(const int& j){
	const double gamma_minus_one = gamma[j]-1;
	m_pj[j] = gamma_minus_one*rho[j]*e[j];
	m_cj[j] = std::sqrt(gamma[j]*gamma_minus_one*e[j]);
      });
  }

  void updateEandCFromRhoP()
  {
    const int nj = m_ej.size();
    const Kokkos::View<const double*> rho = m_rhoj;
    const Kokkos::View<const double*> p = m_pj;
    const Kokkos::View<const double*> gamma = m_gammaj;

    Kokkos::parallel_for(nj, KOKKOS_LAMBDA(const int& j){
	m_ej[j] = p[j]/(rho[j]*(gamma[j]-1));
      });

    const Kokkos::View<const double*> e = m_ej;
    Kokkos::parallel_for(nj, KOKKOS_LAMBDA(const int& j){
	m_cj[j] = std::sqrt(gamma[j]*(gamma[j]-1)*e[j]);
      });
  }
};


#endif // BLOCK_PERFECTGAS_HPP
