#include <language/utils/OFStream.hpp>

#include <utils/Filesystem.hpp>
#include <utils/Messenger.hpp>

OFStream::OFStream(const std::string& filename)
{
  if (parallel::rank() == 0) {
    createDirectoryIfNeeded(filename);
    m_fstream.open(filename);
    if (m_fstream.is_open()) {
      m_ostream = &m_fstream;
    } else {
      std::stringstream error_msg;
      error_msg << "cannot create file " << rang::fgB::yellow << filename << rang::style::reset;
      throw NormalError(error_msg.str());
    }
  }
}
