#include <language/utils/AffectationRegisterForR1.hpp>

#include <language/utils/AffectationProcessorBuilder.hpp>
#include <language/utils/BasicAffectationRegistrerFor.hpp>
#include <language/utils/OperatorRepository.hpp>

void
AffectationRegisterForR1::_register_eq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R1 = ASTNodeDataType::build<ASTNodeDataType::vector_t>(1);

  repository.addAffectation<
    language::eq_op>(R1, ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                     std::make_shared<AffectationProcessorBuilder<language::eq_op, TinyVector<1>, bool>>());

  repository.addAffectation<
    language::eq_op>(R1, ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                     std::make_shared<AffectationProcessorBuilder<language::eq_op, TinyVector<1>, uint64_t>>());

  repository.addAffectation<
    language::eq_op>(R1, ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                     std::make_shared<AffectationProcessorBuilder<language::eq_op, TinyVector<1>, int64_t>>());

  repository.addAffectation<
    language::eq_op>(R1, ASTNodeDataType::build<ASTNodeDataType::double_t>(),
                     std::make_shared<AffectationProcessorBuilder<language::eq_op, TinyVector<1>, double>>());

  repository.addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(R1),
                                             ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                                             std::make_shared<AffectationToTupleProcessorBuilder<TinyVector<1>>>());

  repository.addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(R1),
                                             ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                                             std::make_shared<AffectationToTupleProcessorBuilder<TinyVector<1>>>());

  repository.addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(R1),
                                             ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                                             std::make_shared<AffectationToTupleProcessorBuilder<TinyVector<1>>>());

  repository.addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(R1),
                                             ASTNodeDataType::build<ASTNodeDataType::double_t>(),
                                             std::make_shared<AffectationToTupleProcessorBuilder<TinyVector<1>>>());
}

void
AffectationRegisterForR1::_register_pluseq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R1 = ASTNodeDataType::build<ASTNodeDataType::vector_t>(1);

  repository.addAffectation<language::pluseq_op>(R1, R1,
                                                 std::make_shared<AffectationProcessorBuilder<
                                                   language::pluseq_op, TinyVector<1>, TinyVector<1>>>());
}

void
AffectationRegisterForR1::_register_minuseq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R1 = ASTNodeDataType::build<ASTNodeDataType::vector_t>(1);

  repository.addAffectation<language::minuseq_op>(R1, R1,
                                                  std::make_shared<AffectationProcessorBuilder<
                                                    language::minuseq_op, TinyVector<1>, TinyVector<1>>>());
}

void
AffectationRegisterForR1::_register_multiplyeq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R1 = ASTNodeDataType::build<ASTNodeDataType::vector_t>(1);

  repository.addAffectation<language::multiplyeq_op>(R1, ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyVector<1>, bool>>());

  repository.addAffectation<language::multiplyeq_op>(R1, ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyVector<1>, uint64_t>>());

  repository.addAffectation<language::multiplyeq_op>(R1, ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyVector<1>, int64_t>>());

  repository.addAffectation<language::multiplyeq_op>(R1, ASTNodeDataType::build<ASTNodeDataType::double_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyVector<1>, double>>());
}

AffectationRegisterForR1::AffectationRegisterForR1()
{
  BasicAffectationRegisterFor<TinyVector<1>>{};
  this->_register_eq_op();
  this->_register_pluseq_op();
  this->_register_minuseq_op();
  this->_register_multiplyeq_op();
}
