#include <language/utils/UnaryOperatorRegisterForR2.hpp>

#include <language/utils/OperatorRepository.hpp>
#include <language/utils/UnaryOperatorProcessorBuilder.hpp>

void
UnaryOperatorRegisterForR2::_register_unary_minus()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R2 = ASTNodeDataType::build<ASTNodeDataType::vector_t>(2);

  repository.addUnaryOperator<language::unary_minus>(R2, std::make_shared<UnaryOperatorProcessorBuilder<
                                                           language::unary_minus, TinyVector<2>, TinyVector<2>>>());
}

UnaryOperatorRegisterForR2::UnaryOperatorRegisterForR2()
{
  this->_register_unary_minus();
}
