#include <language/utils/AffectationRegisterForR2.hpp>

#include <language/utils/AffectationProcessorBuilder.hpp>
#include <language/utils/BasicAffectationRegistrerFor.hpp>
#include <language/utils/OperatorRepository.hpp>

void
AffectationRegisterForR2::_register_eq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R2 = ASTNodeDataType::build<ASTNodeDataType::vector_t>(2);

  repository.addAffectation<
    language::eq_op>(R2, ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                     std::make_shared<AffectationFromZeroProcessorBuilder<language::eq_op, TinyVector<2>>>());

  repository.addAffectation<language::eq_op>(R2,
                                             ASTNodeDataType::build<ASTNodeDataType::list_t>(
                                               std::vector<std::shared_ptr<const ASTNodeDataType>>{}),
                                             std::make_shared<AffectationToTinyVectorFromListProcessorBuilder<
                                               language::eq_op, TinyVector<2>>>());

  repository.addAffectation<language::eq_op>(ASTNodeDataType::build<ASTNodeDataType::tuple_t>(R2),
                                             ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                                             std::make_shared<AffectationToTupleProcessorBuilder<TinyVector<2>>>());
}

void
AffectationRegisterForR2::_register_pluseq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R2 = ASTNodeDataType::build<ASTNodeDataType::vector_t>(2);

  repository.addAffectation<language::pluseq_op>(R2, R2,
                                                 std::make_shared<AffectationProcessorBuilder<
                                                   language::pluseq_op, TinyVector<2>, TinyVector<2>>>());
}

void
AffectationRegisterForR2::_register_minuseq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R2 = ASTNodeDataType::build<ASTNodeDataType::vector_t>(2);

  repository.addAffectation<language::minuseq_op>(R2, R2,
                                                  std::make_shared<AffectationProcessorBuilder<
                                                    language::minuseq_op, TinyVector<2>, TinyVector<2>>>());
}

void
AffectationRegisterForR2::_register_multiplyeq_op()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R2 = ASTNodeDataType::build<ASTNodeDataType::vector_t>(2);

  repository.addAffectation<language::multiplyeq_op>(R2, ASTNodeDataType::build<ASTNodeDataType::bool_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyVector<2>, bool>>());

  repository.addAffectation<language::multiplyeq_op>(R2, ASTNodeDataType::build<ASTNodeDataType::unsigned_int_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyVector<2>, uint64_t>>());

  repository.addAffectation<language::multiplyeq_op>(R2, ASTNodeDataType::build<ASTNodeDataType::int_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyVector<2>, int64_t>>());

  repository.addAffectation<language::multiplyeq_op>(R2, ASTNodeDataType::build<ASTNodeDataType::double_t>(),
                                                     std::make_shared<AffectationProcessorBuilder<
                                                       language::multiplyeq_op, TinyVector<2>, double>>());
}

AffectationRegisterForR2::AffectationRegisterForR2()
{
  BasicAffectationRegisterFor<TinyVector<2>>{};
  this->_register_eq_op();
  this->_register_pluseq_op();
  this->_register_minuseq_op();
  this->_register_multiplyeq_op();
}
