#include <utils/Exceptions.hpp>

#include <rang.hpp>

#include <sstream>

NormalError::NormalError(std::string_view error_msg)
  : std::runtime_error([&] {
      std::ostringstream os;
      os << rang::style::bold << "Error:" << rang::style::reset << '\n' << error_msg << '\n';
      return os.str();
    }())
{}

UnexpectedError::UnexpectedError(std::string_view error_msg)
  : std::runtime_error([&] {
      std::ostringstream os;
      os << rang::fgB::red << "Unexpected error:" << rang::style::reset << '\n' << error_msg << '\n';
      return os.str();
    }())
{}

NotImplementedError::NotImplementedError(std::string_view error_msg)
  : std::runtime_error([&] {
      std::ostringstream os;
      os << rang::fgB::yellow << "Not implemented yet:" << rang::style::reset << '\n' << error_msg << '\n';
      return os.str();
    }())
{}
