#include <utils/ConsoleManager.hpp>

#include <rang.hpp>

bool
ConsoleManager::isTerminal(std::ostream& os)
{
  return rang::rang_implementation::isTerminal(os.rdbuf());
}

void
ConsoleManager::init(const bool& colorize)
{
  std::cout << "Console management: color ";
  if (colorize) {
    rang::setControlMode(rang::control::Force);
    std::cout << rang::style::bold << rang::fgB::green << "enabled" << rang::fg::reset << rang::style::reset << '\n';
  } else {
    rang::setControlMode(rang::control::Off);
    std::cout << "disabled\n";
  }
}
