#include <language/utils/UnaryOperatorRegisterForR3.hpp>

#include <language/utils/OperatorRepository.hpp>
#include <language/utils/UnaryOperatorProcessorBuilder.hpp>

void
UnaryOperatorRegisterForR3::_register_unary_minus()
{
  OperatorRepository& repository = OperatorRepository::instance();

  auto R3 = ASTNodeDataType::build<ASTNodeDataType::vector_t>(3);

  repository.addUnaryOperator<language::unary_minus>(R3, std::make_shared<UnaryOperatorProcessorBuilder<
                                                           language::unary_minus, TinyVector<3>, TinyVector<3>>>());
}

UnaryOperatorRegisterForR3::UnaryOperatorRegisterForR3()
{
  this->_register_unary_minus();
}
